<?php

class VFC_HIDE {

    /**
	* The vBulletin registry object
	*
	* @var	vB_Registry
	*/
	
	public $registry = null;
	
	/**
	* Whether html is allowed or not
	*
	* @var	boolean
	*/
	
	public $dohtml = false;
	
	/**
	* Hide Taglist (without option)
	*
	* @var	array
	*/
	
	private $taglist = array(
		'HIDE-REPLY' => 'p_bb_code_hr',
		'HIDE-THANKS' => 'p_bb_code_ht',
		'HIDE-REPLY-THANKS' => 'p_bb_code_hrt'
		);
		
	/**
	* Hide Taglist (with option)
	*
	* @var	array
	*/
	
	private $taglistwo = array(
		'HIDE-POSTS'   => 'p_bb_code_hp',
		'SHOWTOGROUPS' => 'p_bb_code_stg',
		'STU'          => 'p_bb_code_stu'
		);
		
	private $twodefault = array();
		
	/**
	* Post's Details for parsing Hide Tags
	*
	* @var	string
	*/
	
	public $forumid = null;
	public $postid = null;
	public $threadid = null;
	public $userid = null;
	
	/**
	* @var	boolean
	*/
	
	public $owner = false;
	public $hreply = false;
	public $hthanks = false;
	
    private $tagparser;

	
	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	*/
	
	public function __construct(&$registry) 
	{
	
		global $vbphrase, $vbulletin;

		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error("vB_Database::Registry object is not an object", E_USER_ERROR);
		}
		
		if (in_array(THIS_SCRIPT, array('ajax', 'editpost', 'misc', 'newthread', 'newreply', 'printthread', 'showpost', 'showthread')))
		{
			$this->dohtml = true;
		}
		else
		{
			$this->dohtml = false;
		}
		
	
		$this->twodefault = array('HIDE-POSTS' => $this->registry->options['vfc_hide_hack_hr_posts'], 
		                          'SHOWTOGROUPS' => $this->registry->options['hide_hack_sett_grp'],
								  'STU'        => 0
								  );
								  
		$hidetag = $this->registry->options[vfc_hide_hack_hide];
		if ($this->taglist[$hidetag])
		{
		$this->taglist['HIDE'] =& $this->taglist["$hidetag"];
		}
		else
		{
		$this->taglistwo['HIDE'] =& $this->taglistwo["$hidetag"];
		$this->twodefault['HIDE'] =& $this->twodefault["$hidetag"];
		}
		
		/// Calling Parser
		
		require_once( DIR."/includes/vfchh/php/vfc_hide_parser.php" );
        $this->tagparser = new VFC_PARSER($this);		
		
	}
	
	
	/**
	* Main Function which will be used to Parse the tags
	*
	* @param	Message, Forumid, Threadid, Postid, Userid (of creator)
	*
	* @return	Message (Parsed)
	*/

 function fetch_msg_to_hide ($params = array()) 
 {
 
 // Extracting  Params
 
 @extract($params);
 global $vbphrase;

 $this->forumid = $forumid;
 $this->threadid = $threadid;
 $this->postid = $postid;
 $this->userid = $userid;
 $this->hthanks = false;
  
  // Check if this user can bypass hide tags or not
 
 $this->owner = $this->canbypass();

   // Hide Tags without option

  foreach ($this->taglist as $tag => $parser) {
  $message = preg_replace('/\\[' . $tag . '\\](.*)\\[\/' . $tag . '\\]/siU', $this->tagparser->$parser('\\1'), $message);
                                              }
											  
   // Hide Tags with option
   
   foreach ($this->taglistwo as $tag => $parser) {
   $message = preg_replace("/\[" . $tag . "\]/siU", "[".$tag."=".$this->twodefault[$tag]."]", $message);
   $message = preg_replace("/\[" . $tag . "=(&quot;|\"|'|)([0-9,]+)\\1\](.*)\[\/" . $tag . "\]/esiU", "\$this->tagparser->\$parser('\\3', '\\2')", $message);
   $message = preg_replace("/\[" . $tag . "=" . $this->twodefault[$tag] . "\]/siU", '[' . $tag . ']', $message);
	                                             }
   
  return $message;

 }
 
  /**
	* Function for removing hide tags
	*
	* @param	Message
	*
	* @return	Message (Stripped)
	*/
 
  function strip_hide_bbcodes($message, $for = '') 
  {
  global $vbphrase;
  
  $replace = '';
  $replace2 = '';
  
  switch ($for)
  {
    case 'preview':
      $replace = '\\1';
      $replace2 = '\\3';
	  break;
	case 'quote':
	  $replace2 = $replace = $vbphrase['vfc_hide_hack_noquote'];
	  break;
	case 'email':
     $replace2 = $replace = $vbphrase['vfc_hide_hack_email'];
	 break;
	default:
	  $replace2 = $replace = '';
	  break;
  }	  
	

  foreach ($this->taglist as $tag => $parser) {
  $message = preg_replace('/\\[' . $tag . '\\](.*)\\[\/' . $tag . '\\]/siU', $replace, $message);
                                             }
											 
   foreach ($this->taglistwo as $tag => $parser) {
   $message = preg_replace('/\\[' . $tag . '\\](.*)\\[\/' . $tag . '\\]/siU', $replace, $message);
   $message = preg_replace("/\[" . $tag . "=(&quot;|\"|'|)([0-9,]+)\\1\](.*)\[\/" . $tag . "\]/siU", $replace2, $message);
	                                             }											 
 
    return $message;
 
   }
   
    /**
	* Permission for tags
	*
	* @param	Foruminfo
	*
	* @return	Permission
	*/
	
   function check_permission ($foruminfo) 
   {
      $output = array();

    $output[stg] = ($this->registry->options['vfc_hide_hack_stu'] && ($this->registry->userinfo['permissions']['vfc_hide_hack_perm'] & $this->registry->bf_ugp['vfc_hide_hack_perm']['vfc_can_hide_stg'])
	  && $foruminfo['vfchh_stg']);
	
    $output[hide] = ($this->registry->options['vfc_hide_hack_hide'] && ($this->registry->userinfo['permissions']['vfc_hide_hack_perm'] & $this->registry->bf_ugp['vfc_hide_hack_perm']['vfc_can_hide'])
	  && $foruminfo['vfchh_hide']);	
	  
	$output[hreply] = ($this->registry->options['vfc_hide_hack_hr'] && ($this->registry->userinfo['permissions']['vfc_hide_hack_perm'] & $this->registry->bf_ugp['vfc_hide_hack_perm']['vfc_can_hide_reply'])
	  && $foruminfo['vfchh_hreply']);

	$output[hthanks] = ($this->registry->options['vfc_hide_hack_ht'] && ($this->registry->userinfo['permissions']['vfc_hide_hack_perm'] & $this->registry->bf_ugp['vfc_hide_hack_perm']['vfc_can_hide_thanks'])
	  && $foruminfo['vfchh_hthanks'] && ($this->registry->products['post_thanks'] || $this->registry->products['crawlability_vbseo']));

	$output[hrt] = ($this->registry->options['vfc_hide_hack_hrt'] && ($this->registry->userinfo['permissions']['vfc_hide_hack_perm'] & $this->registry->bf_ugp['vfc_hide_hack_perm']['vfc_can_hide_rt'])
	  && $foruminfo['vfchh_hrt'] && ($this->registry->products['post_thanks'] || $this->registry->products['crawlability_vbseo']));

	$output[hposts] = ($this->registry->options['vfc_hide_hack_hp'] && ($this->registry->userinfo['permissions']['vfc_hide_hack_perm'] & $this->registry->bf_ugp['vfc_hide_hack_perm']['vfc_can_hide_posts'])
	  && $foruminfo['vfchh_hposts']);
	  
    return $output;

   }
   
    /**
	* Tags which user can use
	*
	* @param	Foruminfo
	*
	* @return	Permission
	*/
   
   function fetch_tags ($foruminfo) 
   {
   
   $permission = $this->check_permission($foruminfo);
   $tags = array();
   
   if ($permission['hide']) 
   {
   $tags[] = 'Hide';
   $tags[] = '-';
   }
   if ($permission['hreply']) 
   {
   $tags[] = 'HReply';
   }
   if ($permission['hthanks']) 
   {
   $tags[] = 'Hthanks';
   }
   if ($permission['hrt']) 
   {
   $tags[] = 'HReplyThanks';
   $tags[] = '-'; 
   }
   if ($permission['hposts']) 
   {
   $tags[] = 'HPosts';
   }
   if ($permission['stg']) 
   $tags[] = 'Showtogroups';
   
   return $tags;
   
   
   }
   
   /**
	* Function for checking if user can bypass HIDE Tags
	*
	* @param	Foruminfo
	*
	* @return	Permission
	*/
	
	function canbypass () 
	{
	
	   if (($this->registry->userinfo['permissions']['vfc_hide_hack_perm'] & $this->registry->bf_ugp['vfc_hide_hack_perm']['vfc_can_hide_allow']))
       {	   
	        return true;
       }	
	
       if ($this->registry->userinfo[userid] == $this->userid) 
	   {
            return true;
       }
	  
	   if (can_moderate($this->forumid, 'caneditposts'))
	   {
	       return true;
	   }
	  
	       return false;

	}
	
	
	function copyright ($output)
	{
	
       $output = preg_replace('#All rights reserved.#i', 'All rights reserved.<div style="text-align: center">Hide Hack By 
	   <a href="http://vfcoders.com" target="_blank" rel="nofollow">vFCoders</a>.</div>', $output, 1, $match);
	   
	   if (empty($match)) 
	   {
	   
	   $output = preg_replace('#<div id="footer_copyright"#i', '<div style="text-align: center" class="shade footer_copyright">Hide Hack By 
	   <a href="http://vfcoders.com" target="_blank" rel="nofollow">vFCoders</a></div><div id="footer_copyright"', $output, 1, $match);
	   
	   }
	   
	   if (empty($match))
	   {
	   
	   $output = preg_replace('#</body>#i', '<div style="text-align: center" class="shade footer_copyright">Hide Hack By 
	   <a href="http://vfcoders.com" target="_blank" rel="nofollow">vFCoders</a>.</div></body>', $output);
	   
	   }
	   
	   return $output;
                	
	}
	 
}

?>